/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class RotateFilter
extends ImageFilter {
    private byte[][] byte_bits;
    private int[][] int_bits;
    private boolean use_byte;
    private int newWidth;
    private int newHeight;
    private boolean got_part = false;
    private ColorModel model;
    private int angle;
    public static final int DEG_90 = 1;
    public static final int DEG_180 = 2;
    public static final int DEG_270 = 3;

    public RotateFilter(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.angle = n;
                return;
            }
        }
        throw new IllegalArgumentException("RotateFilter needs one of DEG_90, DEG_180 or DEG_270");
    }

    public void imageComplete(int n) {
        int n2 = 0;
        while (n2 < this.newHeight) {
            if (this.use_byte) {
                super.setPixels(0, n2, this.newWidth, 1, this.model, this.byte_bits[n2], 0, this.newWidth);
            } else {
                super.setPixels(0, n2, this.newWidth, 1, this.model, this.int_bits[n2], 0, this.newWidth);
            }
            ++n2;
        }
        super.imageComplete(n);
    }

    private void allocateArray() {
        if (this.got_part) {
            if (this.use_byte) {
                this.byte_bits = new byte[this.newHeight][this.newWidth];
            } else {
                this.int_bits = new int[this.newHeight][this.newWidth];
            }
        }
        this.got_part = true;
    }

    public void setColorModel(ColorModel colorModel) {
        this.use_byte = colorModel.getPixelSize() <= 8;
        this.allocateArray();
        this.model = colorModel;
        super.setColorModel(colorModel);
    }

    public void setDimensions(int n, int n2) {
        switch (this.angle) {
            case 1: 
            case 3: {
                this.newWidth = n2;
                this.newHeight = n;
                break;
            }
            case 2: {
                this.newWidth = n;
                this.newHeight = n2;
                break;
            }
        }
        this.allocateArray();
        super.setDimensions(this.newWidth, this.newHeight);
    }

    public void setHints(int n) {
        super.setHints(n);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        switch (this.angle) {
            case 1: {
                int n7 = 0;
                while (n7 < n3) {
                    this.byte_bits[n7][this.newWidth - n2 - 1] = byArray[n7 + n5];
                    ++n7;
                }
                return;
            }
            case 2: {
                int n8 = 0;
                while (n8 < n3) {
                    this.byte_bits[this.newHeight - n2 - 1][this.newWidth - n8 - 1] = byArray[n8 + n5];
                    ++n8;
                }
                return;
            }
            case 3: {
                int n9 = 0;
                while (n9 < n3) {
                    this.byte_bits[this.newHeight - n9 - 1][n2] = byArray[n9 + n5];
                    ++n9;
                }
                return;
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        switch (this.angle) {
            case 1: {
                int n7 = 0;
                while (n7 < n3) {
                    this.int_bits[n7][this.newWidth - n2 - 1] = nArray[n7 + n5];
                    ++n7;
                }
                return;
            }
            case 2: {
                int n8 = 0;
                while (n8 < n3) {
                    this.int_bits[this.newHeight - n2 - 1][this.newWidth - n8 - 1] = nArray[n8 + n5];
                    ++n8;
                }
                return;
            }
            case 3: {
                int n9 = 0;
                while (n9 < n3) {
                    this.int_bits[this.newHeight - n9 - 1][n2] = nArray[n9 + n5];
                    ++n9;
                }
                return;
            }
        }
    }

    public void setProperties(Hashtable hashtable) {
    }
}

